//=============================================================================
// Wafobar4.
//=============================================================================
class EatingContestWafo extends DeusExPickup;

#exec TEXTURE IMPORT FILE="C:\DeusEx\Markistan\textures\WafoTex4.pcx"			NAME="WafoTex4"				GROUP="Skins" MIPS=Off 
#exec TEXTURE IMPORT FILE="C:\DeusEx\Markistan\textures\BeltIconWafoBar4.pcx"		NAME="BeltIconWafoBar4"				GROUP="Icons" MIPS=Off FLAGS=2
#exec AUDIO IMPORT FILE="C:\DeusEx\DinoVSHuman1_5\Sounds\EatSoyMeal.wav"	NAME="EatSoyMeal"	GROUP="Player"

var int HealAmount;
var MSGamesMutator MSMod;

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return (BeltSpot >= 0);
}

state Activated
{
	function Activate()
	{
     ForEach AllActors(class'MSGamesMutator',MSMod)
     {
       if (MSMod != None)
       {
        if (MSMod.bEating)
        {		// can't turn it off if in contest
	}
        else
        {
          DeusExPlayer(Owner).ClientMessage("|p2An eating contest is not in progress!");
        }
       }
       else
       {
         Super.Activate();;
       }
     }
       }

	function BeginState()
	{
		local DeusExPlayer player;

     ForEach AllActors(class'MSGamesMutator',MSMod)
     {
       if (MSMod != None)
       {
        if (MSMod.bEating)
        {		
		Super.BeginState();

		player = DeusExPlayer(Owner);
		if (player != None)
			player.HealPlayer(HealAmount, False);;

		PlaySound(sound'EatSoyMeal');

         if (playerpawn(Owner) == MSMod.Eater1)
         {
            MSMod.Eater1Score += 1;
         }
         else if (playerpawn(Owner) == MSMod.Eater2)
         {
            MSMod.Eater2Score += 1;
         }
         else if (playerpawn(Owner) == MSMod.Eater3)
         {
            MSMod.Eater3Score += 1;
         }
         else if (playerpawn(Owner) == MSMod.Eater4)
         {
            MSMod.Eater4Score += 1;
         }

		UseOnce();
        } 
       }
     }
	}
Begin:
}

defaultproperties
{
     healAmount=10
     maxCopies=25
     bCanHaveMultipleCopies=True
     bActivatable=True
     ItemName="BlueBerry Wafo Bar"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.Candybar'
     PickupViewMesh=LodMesh'DeusExItems.Candybar'
     ThirdPersonMesh=LodMesh'DeusExItems.Candybar'
     Icon=Texture'MSGames2_3.Icons.BeltIconWafoBar4'
     largeIcon=Texture'MSGames2_3.Icons.BeltIconWafoBar4'
     largeIconWidth=46
     largeIconHeight=36
     Description="'A new brand of candy bar that seems to be related to waffles, this one's blueberry.'"
     beltDescription="WAFO BLBRY"
     Skin=Texture'MSGames2_3.Skins.WafoTex4'
     Mesh=LodMesh'DeusExItems.Candybar'
     CollisionRadius=6.250000
     CollisionHeight=0.670000
     Mass=3.000000
     Buoyancy=4.000000
}
